
//Poisson Distribution
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

Frequency=[12,10,19,17,10,8,7,5,5,3,3,1]
n=sum(Frequency)
X=[0,1,2,3,4,5,6,7,8,9,10,11]

F=[]
P1=[]
P2=[]

mprintf("   --------------------------------\n")
mprintf("   Arrivals             Frequency\n")
mprintf("   --------------------------------")
for i=1:12
    mprintf("\n      %d                     %d",i-1,Frequency(i))
    F($+1)=Frequency(i)
    product1=F(i)*X(i)
    product2=F(i)*(X(i)**2)
    P1($+1)=product1
    P2($+1)=product2
    sumP1 =sum(P1)
    sumP2 =sum(P2)
end
mprintf("\n   --------------------------------")
Xbar = sumP1/n
S_sqr = (sumP2 - n*Xbar**2)/(n-1)
S = sqrt(S_sqr)

//Result
mprintf("\n\n Total number of arrivals = %d",n)
mprintf("\nalpha = Xbar = Sum(fj*Xj)/n = %f",Xbar)
mprintf("\nSample variance = (Sum(fj*Xj^2) - n*Xbar^2) / n-1 = %f",S_sqr)
